/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.plugin;

import net.impactdev.impactor.api.logging.PluginLogger;
import net.impactdev.impactor.api.utility.ExceptionPrinter;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;

public abstract class ImpactorBootstrapper {
    protected final BaseImpactorPlugin plugin;
    private final PluginLogger logger;

    public ImpactorBootstrapper(PluginLogger logger) {
        this.logger = logger;
        this.plugin = this.createPlugin();
    }

    public PluginLogger logger() {
        return this.logger;
    }

    protected abstract BaseImpactorPlugin createPlugin();

    public void construct() {
        try {
            this.plugin.construct();
        }
        catch (Exception e) {
            ExceptionPrinter.print(this.plugin.logger(), e);
        }
    }

    public void setup() {
        try {
            this.plugin.setup();
        }
        catch (Exception e) {
            ExceptionPrinter.print(this.plugin.logger(), e);
        }
    }

    public void shutdown() {
        try {
            this.plugin.shutdown();
        }
        catch (Exception e) {
            ExceptionPrinter.print(this.plugin.logger(), e);
        }
    }
}

